#include <sys/types.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#include <GL/gl.h>
#include <GL/glu.h>


#include <SDL.h>
#include <SDL/SDL_image.h>

#define PI 3.14159265
#define SPHERES 100

/* screen width, height, and bit depth */
int SCREEN_WIDTH=800;
int SCREEN_HEIGHT=600;
int SCREEN_BPP=24;

/* Set up some booleans */
#define TRUE  1
#define FALSE 0

SDL_Surface *display;

GLuint sphere[1];

int 	sphere_x[SPHERES], sphere_y[SPHERES], 
	sphere_xrad[SPHERES], sphere_yrad[SPHERES], 
	sphere_xvel[SPHERES], sphere_yvel[SPHERES], 
	sphere_xoff[SPHERES], sphere_yoff[SPHERES];

GLfloat sphere_r[SPHERES],sphere_g[SPHERES],sphere_b[SPHERES];


int c;

double fastsin[3610], fastcos[3610];

void init_fast_tables() {
	int deg;
	for(deg=0;deg<3610;deg++) {
		fastsin[deg]=sin(deg*0.1* (PI/180));
		fastcos[deg]=cos(deg*0.1* (PI/180));
	}
}

void init_spheres() {
	for(c=0;c<SPHERES;c++) {
		srand48((c + 2) * 100 + sphere_x[c] + time(NULL));
		sphere_x[c]=    (drand48() * 3600);
		sphere_y[c]=    (drand48() * 3600);

		sphere_xrad[c]= (drand48() * 300) +80;
		sphere_yrad[c]= (drand48() * 300) +80;

		sphere_xvel[c]= 3 + (drand48() * 35);
		sphere_yvel[c]= 3 + (drand48() * 35);

		sphere_xoff[c]= -400;
		sphere_yoff[c]= -200;

		if ( drand48() > 0.5 ) {  sphere_xoff[c] = 400; }

		if ( drand48() > 0.8 ) { 
			sphere_r[c]= 1.0f; 
			sphere_g[c]= 0.5f; 
			sphere_b[c]= 0.8f; 
		} else 	if ( drand48() > 0.6 ) { 
			sphere_r[c]= 0.7f; 
			sphere_g[c]= 0.5f; 
			sphere_b[c]= 1.0f; 
		} else if ( drand48() > 0.5 ) { 
			sphere_r[c]= 0.3f;
			sphere_g[c]= 0.9f; 
			sphere_b[c]= 1.0f; 
		} else {
			sphere_r[c]= 1.0f; 
			sphere_g[c]= 1.0f; 
			sphere_b[c]= 1.0f; 
		}
	}
}

void draw_sphere(int x, int y, int c) {
	glColor4f( sphere_r[c], sphere_g[c], sphere_b[c], 0.6f );
	GLfloat fx, fy;
	glBegin(GL_QUADS);
	
	fx=x*0.002;
	fy=y*0.002;
	
        glTexCoord2f( 0.0f, 1.0f ); glVertex3f( -0.5f + fx, fy, -1.0f );
        glTexCoord2f( 1.0f, 1.0f ); glVertex3f(  0.5f + fx, fy, -1.0f );
        glTexCoord2f( 1.0f, 0.0f ); glVertex3f(  0.5f + fx, 1.0f + fy, -1.0f );
        glTexCoord2f( 0.0f, 0.0f ); glVertex3f( -0.5f + fx, 1.0f + fy, -1.0f );
	
	glEnd( );
}

void screensaver() {
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ); 

	glBindTexture( GL_TEXTURE_2D, sphere[0] );
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glRotatef(0.2f, 0.0f, 0.0f, 1.0f);	

	for(c=0;c<SPHERES;c++) {
		sphere_x[c]+=sphere_xvel[c];
		sphere_y[c]+=sphere_yvel[c];
		if (sphere_x[c] >= 3600) {
			sphere_x[c]=0;
		} else if (sphere_x[c] <= 0) { 
			sphere_x[c]=3600;
		}
		if (sphere_y[c] >= 3600) {
			sphere_y[c]=0;
		} else if (sphere_y[c] <= 0) { 
			sphere_y[c]=3600;
		}

		draw_sphere( (fastsin[sphere_x[c]]*sphere_xrad[c])+sphere_xoff[c], ( fastcos[sphere_y[c]]*sphere_yrad[c])+sphere_yoff[c], c );
	}
	SDL_GL_SwapBuffers( );
	SDL_Delay(60);
}


int main( int argc, char *argv[] ) {

	SDL_Init( SDL_INIT_VIDEO );
	SDL_Init( SDL_INIT_AUDIO );

	init_fast_tables();
	init_spheres();
	
	atexit(SDL_Quit);

	SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );

	display = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP,  SDL_HWSURFACE | SDL_GL_DOUBLEBUFFER | SDL_NOFRAME | SDL_OPENGL);

	SDL_ShowCursor(0);

	glViewport( 0, 0, ( GLint )SCREEN_WIDTH, ( GLint )SCREEN_HEIGHT );
	glMatrixMode( GL_PROJECTION );
	gluPerspective( 30.0f, ( GLfloat )SCREEN_WIDTH / SCREEN_HEIGHT , 0.1f, 100.0f );
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity( );
 

	glEnable( GL_TEXTURE_2D );
	glShadeModel( GL_FLAT );
	glEnable(GL_BLEND);
	glClearDepth( 1.0f );
	
	SDL_Surface *image;
	glGenTextures(1, &sphere[0]);

	image=IMG_Load("data/glow_white.png");
	glBindTexture( GL_TEXTURE_2D, sphere[0] );
	glTexImage2D( GL_TEXTURE_2D, 0, 3, image->w, image->h, 0, GL_RGB, GL_UNSIGNED_BYTE, image->pixels );
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
	SDL_FreeSurface(image);

	glLoadIdentity( );
	glTranslatef( 0.0f, 0.0f, -5.5f );

	int done=0;
	
	SDL_Event event;
	while(done == 0) {
		while(SDL_PollEvent(&event)) {
			if ( ( event.type == SDL_QUIT ) || ( event.type == SDL_KEYDOWN ) ) { done = 1; } ;
		}
		screensaver();
        }
	return 0;
}
