#include <sys/types.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#ifdef __linux__
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#endif

#include <SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_mixer.h>

#include <id3tag.h>

/* screen width, height, and bit depth */
int SCREEN_WIDTH=800;
int SCREEN_HEIGHT=600;
int SCREEN_BPP=16;

/* Set up some booleans */
#define TRUE  1
#define FALSE 0

#define FONTSIZE 30

char filename[MAXPATHLEN];

SDL_Color colors[256];

SDL_Surface *display;

SDL_Rect dstrect, srcrect, dstvol, srcvol;

SDL_Surface *background, *textout, *volume;

TTF_Font *font;
SDL_Color col_white = { 0xff, 0xff, 0xff, 0 };
SDL_Color col_green = { 0x55, 0xff, 0x44, 0 };
SDL_Color col_black = { 0x00, 0x00, 0x00, 0 };

char out[256];

char id3_title[35];
char id3_artist[35];
char id3_album[35];
char id3_year[10];
char id3_track[10];

/* Convenience for retrieving already formatted id3 data
 * what parameter is one of
 *  ID3_FRAME_TITLE
 *  ID3_FRAME_ARTIST
 *  ID3_FRAME_ALBUM
 *  ID3_FRAME_YEAR
 *  ID3_FRAME_COMMENT
 *  ID3_FRAME_GENRE
 * It allocates a new string. Free it later.
 * NULL if no tag or error.
 */
char *id3_get_tag (struct id3_tag const *tag, char const *what, unsigned int maxlen)
{
    struct id3_frame const *frame = NULL;
    union id3_field const *field = NULL;
    int nstrings;
    int avail;
    int j;
    int tocopy;
    int len;
    char printable [1024];
    char *retval = NULL;
    id3_ucs4_t const *ucs4 = NULL;
    id3_latin1_t *latin1 = NULL;

    memset (printable, '\0', 1024);
    avail = 1024;
    if (strcmp (what, ID3_FRAME_COMMENT) == 0)
    {
        /*There may be sth wrong. I did not fully understand how to use
            libid3tag for retrieving comments  */
        j=0;
        frame = id3_tag_findframe(tag, ID3_FRAME_COMMENT, j++);
        if (!frame) return (NULL);
        ucs4 = id3_field_getfullstring (&frame->fields[3]);
        if (!ucs4) return (NULL);
        latin1 = id3_ucs4_latin1duplicate (ucs4);
        if (!latin1 || strlen(latin1) == 0) return (NULL);
        len = strlen(latin1);
        if (avail > len)
            tocopy = len;
        else
            tocopy = 0;
        if (!tocopy) return (NULL);
        avail-=tocopy;
        strncat (printable, latin1, tocopy);
        free (latin1);
    }
    
    else
    {
        frame = id3_tag_findframe (tag, what, 0);
        if (!frame) return (NULL);
        field = &frame->fields[1];
        nstrings = id3_field_getnstrings(field);
        for (j=0; j<nstrings; ++j)
        {
            ucs4 = id3_field_getstrings(field, j);
            if (!ucs4) return (NULL);
            if (strcmp (what, ID3_FRAME_GENRE) == 0)
                ucs4 = id3_genre_name(ucs4);
            latin1 = id3_ucs4_latin1duplicate(ucs4);
            if (!latin1) break;
            len = strlen(latin1);
            if (avail > len)
                tocopy = len;
            else
                tocopy = 0;
            if (!tocopy) break;
            avail-=tocopy;
            strncat (printable, latin1, tocopy);
            free (latin1);
        }
    }
    retval = malloc (maxlen + 1);
    if (!retval) return (NULL);

    strncpy (retval, printable, maxlen);
    retval[maxlen] = '\0';

    len = strlen(printable);
    if (maxlen > len)
    {
        memset (retval + len, ' ', maxlen - len);
    }

    return (retval);
}

void draw_text ( char *text, int x, int y , SDL_Color color, int length) {

        if ( x > SCREEN_WIDTH - FONTSIZE || y > SCREEN_HEIGHT - FONTSIZE ) { return; }

        srcrect.x = 0;
        srcrect.y = 0;
        srcrect.w = length;
        srcrect.h = FONTSIZE * 2 ;
        
	textout = TTF_RenderText_Blended( font, text , col_black);
        dstrect.x = x+2;
        dstrect.y = y+2;
        SDL_BlitSurface(textout, &srcrect, display, &dstrect );
        dstrect.x = x+1;
        dstrect.y = y+1;
        SDL_BlitSurface(textout, &srcrect, display, &dstrect );
        SDL_FreeSurface(textout);
        textout = TTF_RenderText_Blended( font, text , color);
        dstrect.x = x;
        dstrect.y = y;
        SDL_BlitSurface(textout, &srcrect, display, &dstrect );
	SDL_FreeSurface(textout);
}

void read_id3_tags ( char *filename ) {
	struct id3_file *id3struct = NULL;
	struct id3_tag *id3tag = NULL;

	id3struct = id3_file_open (filename, ID3_FILE_MODE_READONLY);

	if (id3struct) {
		id3tag = id3_file_tag (id3struct);
		if (id3tag) {
			sprintf ( id3_title,"%s", id3_get_tag(id3tag, ID3_FRAME_TITLE ,35));
			sprintf ( id3_artist,"%s", id3_get_tag(id3tag, ID3_FRAME_ARTIST ,35));
			sprintf ( id3_album,"%s", id3_get_tag(id3tag, ID3_FRAME_ALBUM ,35));
			sprintf ( id3_year,"%s", id3_get_tag(id3tag, ID3_FRAME_YEAR ,4));
			sprintf ( id3_track,"%s", id3_get_tag(id3tag, ID3_FRAME_TRACK ,2));
		}
	} 
}

char *show_id3 ( char *in ) {

	read_id3_tags( in );

	if ( strcmp (id3_title, "(null)" ) ) {
		sprintf ( out, "%s", id3_title );
	} else {
		if (  rindex ( in, '/' ) ) {
			sprintf ( out, "%s", rindex ( in, '/' ) );
		} else {
			sprintf ( out, "%s", in);
		}
	}
	return out;
}


int main( int argc, char *argv[] ) {


	SDL_Init( SDL_INIT_VIDEO );
	SDL_Init( SDL_INIT_AUDIO );
	
	TTF_Init();

	atexit(Mix_CloseAudio);
	atexit(TTF_Quit);
	atexit(SDL_Quit);

	display = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP,  SDL_HWSURFACE | SDL_DOUBLEBUF | SDL_NOFRAME);

	SDL_SetColors(display, colors, 0, 256);

	SDL_ShowCursor(0);

	background = IMG_Load( "data/mp3background.png");
	volume = IMG_Load( "data/volume.png");

	font = TTF_OpenFont( "data/font.ttf", FONTSIZE);
	TTF_SetFontStyle(font, TTF_STYLE_NORMAL);


	Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 1024);

	
	int done=0;
	int n=1;
	int switch_track=0;
	int music_position=0;
	int starttime;
	char textstring[128];

	
	Mix_Music *music;

	SDL_Event event;

#ifdef __linux__
        dstvol.x = 60;
        dstvol.y = 550;
	dstvol.w = 670;
	dstvol.h = 30;

        srcvol.x = 0;
        srcvol.y = 0;
        srcvol.h = 30;

        int mixdev;
        int vol;
        int master = 50;
        int oldvol;
        mixdev = open( "/dev/mixer" , O_RDONLY);
        ioctl(mixdev, MIXER_READ(SOUND_MIXER_VOLUME), &vol);
        oldvol  =  ( (vol & 0xff) + ( (vol & 0xff00) >> 8))/2 ;

        srcvol.w = oldvol * 6.7;
#endif


	while( done == 0) {

		SDL_SetAlpha(background, SDL_RLEACCEL | SDL_SRCALPHA , SDL_ALPHA_OPAQUE);
		SDL_BlitSurface(background, NULL , display, NULL);

		if (  n > 1 ) {
			sprintf ( textstring, "%s", show_id3 ( argv[n-1]) );
			draw_text ( textstring, 100, 340, col_white, 600);
		}
		if (  n +1 < argc ) {
			sprintf ( textstring, "%s", show_id3 ( argv[n+1]) );
			draw_text ( textstring, 100, ( FONTSIZE * 3) + 340, col_white, 600);
		}
		if (  n +2 < argc ) {
			sprintf ( textstring, "%s", show_id3 ( argv[n+2]) );
			draw_text ( textstring, 100, ( FONTSIZE * 4.5) + 340, col_white, 600);
		}
		SDL_SetAlpha(background, SDL_RLEACCEL | SDL_SRCALPHA , 128);
		SDL_BlitSurface(background, NULL , display, NULL);

		sprintf ( textstring, "%i/%i", n, argc -1  );
		draw_text ( textstring, 60, 80, col_white, 540);
		
		sprintf ( textstring, "%s", show_id3( argv[n] ) );
		draw_text ( textstring, 100, ( FONTSIZE * 1.5) + 340, col_green, 600);
		free(textstring);

		if ( strcmp (id3_title , "(null)" ) ) { 
			draw_text ( id3_title, 400, 80, col_white, 400);
		}
		if ( strcmp (id3_artist , "(null)" ) ) { 
			draw_text ( id3_artist, 400, ( FONTSIZE * 2) + 80, col_white, 400);
		}
		if ( strcmp (id3_album , "(null)" ) ) { 
			draw_text ( id3_album, 400, ( FONTSIZE * 3.5) + 80, col_white, 400);
		}
		if ( strcmp (id3_year , "(null)" ) ) { 
			draw_text ( id3_year, 400, ( FONTSIZE * 5) + 80, col_white, 400);
		}
#ifdef __linux__
		SDL_BlitSurface(volume, &srcvol , display, &dstvol );
#endif
		SDL_Flip(display);

		printf( "playing: %s\n", argv[n]);

		music=Mix_LoadMUS(argv[n]);
		starttime =  time( NULL );
		music_position=0;
		Mix_PlayMusic(music, 0);
		switch_track=0;

		while (	done == 0 && switch_track ==0 && (Mix_PlayingMusic() || Mix_PausedMusic() ) ) {
               		SDL_Delay(200);
#ifdef __linux__
			ioctl(mixdev, MIXER_READ(SOUND_MIXER_VOLUME), &vol);
			master  =  ( (vol & 0xff) + ( (vol & 0xff00) >> 8))/2 ;
			if ( oldvol != master ) {
			        printf("Master %d %%\n", master );
				oldvol = master;
				
			        srcvol.w = oldvol * 6.7;
			        
				SDL_SetAlpha(background, SDL_RLEACCEL | SDL_SRCALPHA , SDL_ALPHA_OPAQUE);
				SDL_BlitSurface(background, &dstvol , display, &dstvol );
				SDL_BlitSurface(volume, &srcvol , display, &dstvol );
				SDL_UpdateRect(display, 60, 550, 670, 30);
			}
#endif

	        	while ( SDL_PollEvent(&event) ) {
				if ( event.type == SDL_QUIT ) { done = 1; } ;
	               		if ( event.type == SDL_KEYDOWN ) { 
	               			if ( event.key.keysym.sym == SDLK_ESCAPE ) { 
	               				done = 1;  
	               			} else if ( event.key.keysym.sym == SDLK_UP ) { 
	               				switch_track= 1;
						if ( n > 1) { n--; }
	               			} else if ( event.key.keysym.sym == SDLK_DOWN || event.key.keysym.sym == SDLK_RETURN) { 
	               				switch_track= 1;
	               				n++;
	               			} else if ( event.key.keysym.sym == SDLK_SPACE ) { 
						if ( Mix_PausedMusic() ) { 
							Mix_ResumeMusic(); 
							starttime = time( NULL ) - music_position ;
						} else {
							Mix_PauseMusic();
							music_position = time(NULL) - starttime;
						} 
	               			} else if ( event.key.keysym.sym == SDLK_LEFT ) { 
						starttime +=5;
						music_position = time(NULL) - starttime;
						if (  music_position < 0 ) {  
							music_position =0;
							starttime =  time( NULL ); 
							}
						Mix_RewindMusic();
						Mix_SetMusicPosition(music_position);
	               			} else if ( event.key.keysym.sym == SDLK_RIGHT ) { 
						starttime -=5;
						music_position = time(NULL) - starttime;
						Mix_RewindMusic();
						Mix_SetMusicPosition(music_position);
	               			} else if ( event.key.keysym.sym == SDLK_PAGEDOWN ) { 
						starttime +=60;
						music_position = time(NULL) - starttime;
						if (  music_position < 0 ) {  
							music_position =0;
							starttime =  time( NULL ); 
							}
						Mix_RewindMusic();
						Mix_SetMusicPosition(music_position);
	               			} else if ( event.key.keysym.sym == SDLK_PAGEUP ) { 
						starttime -=60;
						music_position = time(NULL) - starttime;
						Mix_RewindMusic();
						Mix_SetMusicPosition(music_position);
	               			}
	               		}
	               	}
               	}
		if ( switch_track ==0 ) { n++; }
		if ( n == argc ) { done = 1; }
        }
#ifdef __linux__
        close(mixdev);
#endif
	return 0;
}

