#include <sys/types.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <math.h>

#ifdef __linux__
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#endif

#include <SDL.h>
#include "SDL_thread.h"
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_mixer.h>

/* screen width, height, and bit depth */
int SCREEN_WIDTH=800;
int SCREEN_HEIGHT=600;
int SCREEN_BPP=16;

/* Set up some booleans */
#define TRUE  1
#define FALSE 0

#define FONTSIZE 26
int scrollength=8000;

char ok_chars[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-.@ <>:*+!\"$%&/()=?'";

SDL_Color colors[256];

SDL_Surface *display;

SDL_Rect dstrect, srcrect, dstvol, srcvol;

SDL_Surface *background, *backbuffer, *highlight, *backlight, *textback, *frame, *selectbox, *volume, *textout, *textfront;

TTF_Font *font;
SDL_Color col_white = { 0xff, 0xff, 0xff, 0 };
SDL_Color col_black = { 0x00, 0x00, 0x00, 0 };
SDL_Color col_blue  = { 0xaa, 0xaa, 0xff, 0 };

SDL_Color col_file = { 0xff, 0xff, 0xff, 0 };
SDL_Color col_dir  = { 0xaa, 0xaa, 0xff, 0 };
SDL_Color col_shadow  = { 0x00, 0x00, 0x00, 0 };

SDL_Thread *readmixer;

Mix_Chunk *move1_snd, *move2_snd, *open_snd, *close_snd, *vol_snd;

int soundflip=0;

int mixerstate=1, mixerfade=0;

char rootpath[MAXPATHLEN]="/kahuna/multimedia/video";
char player[MAXPATHLEN]="/usr/local/bin/mplayer -quiet -v -fs -novm";
char encoder[MAXPATHLEN]="/usr/local/bin/mencoder -v";

char rightpath[MAXPATHLEN];
char leftpath[MAXPATHLEN];

struct files {
	char filename[MAXPATHLEN];
	unsigned char type;
};

struct files leftpane[1024];
struct files rightpane[1024];

struct { 
	int leftentry; 
	int rightentry; 
	int pane; 
	int oldentry[255]; 
	int level;
	} cursor;

int leftfiles;
int rightfiles;

int language = 0;
int subtitle = 0;
struct { char lang[6]; } alang[16];
struct { char lang[6]; } slang[16];

char *stringclean ( char *string ) {
	char * cp;
	for (cp = string; *(cp += strspn(cp, ok_chars)); ) { *cp = ' '; }
	return string;
}


void sound_move() {
	if ( soundflip ) { 
		Mix_PlayChannel(-1, move1_snd, 0);
	} else {
		Mix_PlayChannel(-1, move2_snd, 0);
	}
	soundflip = !soundflip; 
}

int draw_mixer () {
#ifdef __linux__
        int mixdev;
        int vol;
        int master = 50;
        int oldvol;
        mixdev = open( "/dev/mixer" , O_RDONLY);
	ioctl(mixdev, MIXER_READ(SOUND_MIXER_VOLUME), &vol);
	oldvol  =  ( (vol & 0xff) + ( (vol & 0xff00) >> 8))/2 ;
	while ( mixerstate == 1 ) {
	        ioctl(mixdev, MIXER_READ(SOUND_MIXER_VOLUME), &vol);
	        master  =  ( (vol & 0xff) + ( (vol & 0xff00) >> 8))/2 ;
		if ( oldvol != master ) {
		        printf("Master %d %%\n", master );
			Mix_PlayChannel(-1, vol_snd, 0);
		        oldvol = master;
			mixerfade = 4;
		}
		if ( mixerfade > 0 ) {
			mixerfade--;
			dstvol.x = 60;
			dstvol.y = 550;
			dstvol.w = 670;
			dstvol.h = 30;

			srcvol.x = 0;
			srcvol.y = 0;
			srcvol.w = master * 6.7;
			srcvol.h = 30;


			SDL_BlitSurface(background, &dstvol , display, &dstvol);
			SDL_SetAlpha(volume, 0 | SDL_SRCALPHA , mixerfade * 56); 
			SDL_BlitSurface(volume, &srcvol , display, &dstvol );
			SDL_UpdateRect(display, 60, 550, 670, 30);
		}
		SDL_Delay(200);
	}
        close(mixdev);
#endif
	return 0;
}

void sound_state( int state) {
	if ( state == 1) {
		mixerstate = 1;
	     	Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 1024);
		open_snd=Mix_LoadWAV("data/open.wav");
		move1_snd=Mix_LoadWAV("data/move1.wav");
		move2_snd=Mix_LoadWAV("data/move2.wav");
		close_snd=Mix_LoadWAV("data/close.wav");
		vol_snd=Mix_LoadWAV("data/volume.wav");
		Mix_AllocateChannels(16);
		readmixer = SDL_CreateThread(draw_mixer, NULL);
		if ( readmixer == NULL ) {
	        	fprintf(stderr, "Unable to create thread: %s\n", SDL_GetError());
	        }
	} else {
		mixerstate = 0;
		SDL_WaitThread(readmixer, NULL);
		Mix_CloseAudio();
	}
};

void show_thumbnail (char *thumbname) {
	FILE *file, *fopen();
	
	if ( (file = fopen( thumbname, "r")) == NULL) {
		printf("no thumbnail %s\n.", thumbname );
		return;
	} else {
		printf("loading thumbnail %s\n.", thumbname );

		SDL_Surface *thumbnail;

                dstrect.x = 25;
                dstrect.y = 320;
                dstrect.w = 300;
                dstrect.h = 200;

                srcrect.x = 0;
                srcrect.y = 0;
                srcrect.w = 300;
                srcrect.h = 200;

                thumbnail = IMG_Load(thumbname);
                SDL_BlitSurface(thumbnail, &srcrect, display, &dstrect );

		dstrect.x = 13;	
		dstrect.y = 310;

		SDL_BlitSurface(frame, NULL , display, &dstrect );

                SDL_FreeSurface(thumbnail);
	}
	fclose(file);
};

void draw_text ( char *text, int x, int y , SDL_Color color, int selected, int length) {

	if ( x > SCREEN_WIDTH - FONTSIZE || y > SCREEN_HEIGHT - FONTSIZE ) { return; }


        srcrect.x = 0;
        srcrect.y = 0;
	srcrect.w = length;
	srcrect.h = FONTSIZE * 2 ;

	if ( selected == 1 ) {
		dstrect.x = x;
		dstrect.y = y + 10;
		SDL_BlitSurface(backlight, &srcrect, display, &dstrect );
	} else if ( selected == 2 ) {
		dstrect.x = x;
		dstrect.y = y + 10;
		SDL_BlitSurface(highlight, &srcrect, display, &dstrect );
	}

	textout = TTF_RenderText_Blended( font, text , col_shadow);
	dstrect.x = x+2;
	dstrect.y = y+2;
	SDL_BlitSurface(textout, &srcrect, display, &dstrect );
	dstrect.x = x+1;
	dstrect.y = y+1;
	SDL_BlitSurface(textout, &srcrect, display, &dstrect );
	SDL_FreeSurface(textout);

	textout = TTF_RenderText_Blended( font, text , color);
	dstrect.x = x;
	dstrect.y = y;
	SDL_BlitSurface(textout, &srcrect, display, &dstrect );
	SDL_FreeSurface(textout);

};

int file_select(struct direct *entry) {
		char *name = entry->d_name;
		int type = entry->d_type;
 		if (
		        type !=4
		     && type !=8
		    ) { 
			return (FALSE);
		}
 		if (
		        (strncmp(name, ".", 1)== 0)
		     || (strncmp(name, "..", 2) == 0)
		    ) { 
			return (FALSE);
		}

		/* Check for filename extensions */
		char *ptr;
		ptr  = rindex(name, '.');
		if ( ( type == 4 ) || ( (ptr != NULL) &&
		 (
		    (strcmp(ptr, ".mp3") == 0)
		    || (strcmp(ptr, ".mpg") == 0)
		    || (strcmp(ptr, ".ogm") == 0)
		    || (strcmp(ptr, ".avi") == 0)
		    || (strcmp(ptr, ".divx") == 0)
		    || (strcmp(ptr, ".mkv") == 0)
		    || (strcmp(ptr, ".mpeg") == 0)
		    || (strcmp(ptr, ".txt") == 0)
		    || (strcmp(ptr, ".c") == 0)
		 ) ) ) {
			return (TRUE);
		}
	return(FALSE);
}

void read_dirs ( int pane ) {

	struct direct **files;
	char fullpath[MAXPATHLEN];
	int entry;

	if ( pane == 0 ) {
		entry=0;
		leftpane[entry].type=0;

		sprintf( fullpath, "%s/%s", rootpath,leftpath  );

		leftfiles = scandir(fullpath, &files,(void *) file_select, alphasort);

	 	while( entry < leftfiles && entry < 1024 ) {
			strncpy( leftpane[entry].filename , files[entry]->d_name, 255);
			leftpane[entry].type = files[entry]->d_type;
			entry++;
		}
	}

	if ( pane == 1 ) {
		entry=0;
		rightpane[entry].type=0;

		sprintf( fullpath, "%s/%s", rootpath, rightpath ); 

		rightfiles = scandir(fullpath, &files, (void *) file_select , alphasort);

	 	while( entry < rightfiles && entry < 1024 ) {
			strncpy( rightpane[entry].filename , files[entry]->d_name, 255);
			rightpane[entry].type = files[entry]->d_type;
			entry++;
		}
	}

}



void draw_menu (int sound) {

	
	int entry;
	int offset;
	int view;	
	int viewcenter;
	int x,y,w,h;

	SDL_Color color ;


	if ( sound ) { sound_move(); };

        /* draw leftpane */
        	
       	offset=0;
        view=9; 
        viewcenter=view/2;
	x = 40;
	y = 32;
	w = 274;
	h = (view +1 )* FONTSIZE ;
                        
	srcrect.x = x;
	srcrect.y = y;
	srcrect.w = w+2;
	srcrect.h = h;
		
        dstrect.x = x; 
        dstrect.y = y;
        
	SDL_BlitSurface(background, NULL , display, NULL); 

	entry=0;

	if ( cursor.leftentry >= leftfiles ) { 
		cursor.leftentry = 0; 
	} else if ( cursor.leftentry < 0 ) { 
		cursor.leftentry = leftfiles-1; 
	}

	if ( leftfiles > view ) {
		if ( cursor.leftentry > viewcenter && cursor.leftentry < leftfiles - viewcenter ) {  
			entry = cursor.leftentry - viewcenter;
		} else if ( cursor.leftentry >= leftfiles - viewcenter ) {
			entry = leftfiles  - view ;
		}
	}

	while ( entry < leftfiles && offset < view )  {
		
		if ( leftpane[entry].type == 4 ) { 
			color = col_dir;
		} else {
			color = col_file;
		}

		if ( entry == cursor.leftentry && cursor.pane==0 ) {
			draw_text( leftpane[entry].filename, x,y + offset * FONTSIZE, color, 2, w);
		} else if ( entry == cursor.leftentry ) {
			draw_text( leftpane[entry].filename, x,y + offset * FONTSIZE, color, 1, w);
		} else {
			draw_text( leftpane[entry].filename, x,y + offset * FONTSIZE, color, 0, w);
		} 

		entry++;
		offset++;
	}

        /* draw rightpane */
        	
       	offset=0;
        view=18; 
        viewcenter=view/2;
	x = 345;
	y = 32;
	w = 400;
	h = (view +1 )* FONTSIZE ;

                        
	srcrect.x = x;
	srcrect.y = y;
	srcrect.w = w+2;
	srcrect.h = h;
		
        dstrect.x = x; 
        dstrect.y = y;
                
	entry=0;

	if ( cursor.rightentry >= rightfiles ) { 
		cursor.rightentry = 0; 
	} else if ( cursor.rightentry < 0 ) { 
		cursor.rightentry = rightfiles-1; 
	}

	if ( rightfiles > view ) {
		if ( cursor.rightentry > viewcenter && cursor.rightentry < rightfiles - viewcenter ) {  
			entry = cursor.rightentry - viewcenter;
		} else if ( cursor.rightentry >= rightfiles - viewcenter ) {
			entry = rightfiles  - view ;
		}
	}
	
	while ( entry < rightfiles && offset < view )  {
		if ( rightpane[entry].type == 4 ) { 
			color = col_dir;
		} else {
			color = col_file;
		}

		if ( entry == cursor.rightentry && cursor.pane==1 ) {
			draw_text( rightpane[entry].filename, x,y + offset * FONTSIZE, color, 2, w);
		} else if ( entry == cursor.rightentry ) {
			draw_text( rightpane[entry].filename, x,y + offset * FONTSIZE, color, 1, w);
		} else {
			draw_text( rightpane[entry].filename, x,y + offset * FONTSIZE, color, 0, w);
		} 

		entry++;
		offset++;
	}
	char thumbname[MAXPATHLEN];

	if ( cursor.pane==1 ) {
		sprintf( thumbname,"%s/%s/.%s.png", rootpath, rightpath, rightpane[cursor.rightentry].filename );
	} else {
		sprintf( thumbname,"%s/%s/.%s.png", rootpath, leftpath, leftpane[cursor.leftentry].filename );
	}
	show_thumbnail (thumbname);
 	SDL_Flip(display);
 };

void draw_submenu ( int alangid, int slangid, int menu) {
	int id;
	int x,y,w,h;
	x = 180;
	y = 140;
	w = 100;
	h = 280;

       	dstrect.x = 140;
       	dstrect.y = 140;
       	srcrect.x = 10;
	srcrect.y = 40;
	srcrect.w = 540;
	srcrect.h = 280;

	SDL_BlitSurface(selectbox, &srcrect , display, &dstrect); 
	draw_text( "audio language:", x ,y, col_blue, 0, 400);
	y += ( FONTSIZE * 1.5 );
	x = 180;
	id=0;
	while ( id < language ) {
		if ( alangid == id ) {
			if ( menu ) {
				draw_text( alang[id].lang, x, y, col_white, 2, w);
			} else {
				draw_text( alang[id].lang, x, y, col_white, 1, w);
			}
		} else {
			draw_text( alang[id].lang, x,y , col_white, 0, w);
		}
		x += ( w + 6);
		if ( x > 600 ) {
			 x = 180;
			 y += ( FONTSIZE *2 );
		}
		id++;
	}

	y += ( FONTSIZE *2 );
	x = 180;

	id=0;
	draw_text( "subtitle language:", x ,y, col_blue, 0, 400);
	y += ( FONTSIZE * 1.5 );
	x = 180;
	while ( id < subtitle ) {
		if ( slangid == id ) {
			if ( !menu ) {
				draw_text( slang[id].lang, x, y, col_white, 2, w);
			} else {
				draw_text( slang[id].lang, x, y, col_white, 1, w);
			}
		} else {
			draw_text( slang[id].lang, x,y , col_white, 0, w);
		}
		x += ( w + 6);
		if ( x > 600 ) {
			 x = 180;
			 y += FONTSIZE *2;
		}
		id++;
	}
	sound_move();
	SDL_UpdateRect(display, 180, 140, 500, 280);
}

void select_subtitle ( char *filename ) {

		int menu = -1;
		int alangid = 0;
		int slangid = 0;
		char buffer[100];
        	
        	char command[MAXPATHLEN];
        
		int id = 0;

		while ( id < 15 ) {
			sprintf( alang[id].lang, "lang%i", id);
			sprintf( slang[id].lang, "sub%i", id);
			id++;
		}

		id=0;
		
		language=3;
		subtitle=2;
                char *ptr;
                ptr  = rindex(filename, '.'); 

		FILE *file;
		sprintf( command, "%s \"%s\" ", encoder, filename);
		printf( "loding: %s\n", command);
		file = popen( command, "r" );

		if ( strcmp( ptr, ".ogm") == 0 ) {
			language=0;
			subtitle=0;
			printf("parsing OGM:\n");
			while (!feof(file)) {
        		        fgets(buffer, 100, file);
		                if (strstr( buffer, "Found audio")) { language++; }
		                if (strstr( buffer, "is text")) { subtitle++; }
		        }
		        printf("Audio: %i, Subtitle: %i\n", language, subtitle);
		} else if ( strcmp( ptr, ".mkv") == 0 ) {
			language=0;
			subtitle=0;
			printf("parsing MKV:\n");

                        while (!feof(file)) {
                                fgets(buffer, 100, file);
		                if (strstr( buffer, "alang ")) {
		                        strncpy( alang[language].lang, rindex(buffer, ' '),4);
		                        alang[language].lang[4]='\0';
		                        language++;
		                }
		                if (strstr( buffer, "slang ")) {
		                        strncpy( slang[subtitle].lang, rindex(buffer, ' '),4 );
		                        slang[subtitle].lang[4]='\0';
		                        subtitle++; 
		                }
		        }
		        printf("Audio: %i, Subtitle: %i\n", language, subtitle);
		}
		pclose(file);

		strcpy( slang[subtitle].lang, "none");
		subtitle++;

        	dstrect.x = 130;
        	dstrect.y = 100;
        	dstrect.w = 500;
        	dstrect.h = 500;

		SDL_BlitSurface(selectbox, NULL , display, &dstrect);
		TTF_SetFontStyle(font, TTF_STYLE_BOLD);

		dstrect.w = 900;
		dstrect.h = FONTSIZE * 2;
		
	        srcrect.x = 0;
	        srcrect.y = 0;
		srcrect.w = 630;
		srcrect.h = 450;

		textout = TTF_RenderText_Blended( font, rindex( filename,'/'), col_shadow);
		dstrect.x = 152;
		dstrect.y = 102;
		SDL_BlitSurface(textout, &srcrect, display, &dstrect );
		dstrect.x = 151;
		dstrect.y = 101;
		SDL_BlitSurface(textout, &srcrect, display, &dstrect );
		SDL_FreeSurface(textout);
		
		textout = TTF_RenderText_Blended( font, rindex( filename,'/'), col_file);
		dstrect.x = 150;
		dstrect.y = 100;
		SDL_BlitSurface(textout, &srcrect, display, &dstrect );
		SDL_FreeSurface(textout);

		TTF_SetFontStyle(font, TTF_STYLE_NORMAL);
		SDL_Flip( display);

        	dstrect.x = 140;
        	dstrect.y = 140;
        	srcrect.x = 10;
        	srcrect.y = 10;
        	srcrect.w = 540;
        	srcrect.h = 280;

 		draw_submenu ( alangid, slangid, menu);

		int done = 0;

		SDL_Event event;
		while(done == 0) {
	        	if ( SDL_WaitEvent(&event) ) {
				if ( event.type == SDL_QUIT || event.key.keysym.sym == SDLK_ESCAPE ) { 
					draw_menu(1);
					done = 1;
				}
				if ( event.type == SDL_KEYDOWN ) {
					if ( event.key.keysym.sym == SDLK_SPACE || event.key.keysym.sym == SDLK_RETURN ) { 
						Mix_PlayChannel(-1, open_snd, 0);
						SDL_Delay(1500);
						sound_state(0);
						sprintf( command, "%s -aid %i -sid %i \"%s\"", player, alangid, slangid, filename);
						system( command );
						printf ("%s\n", command);
						sound_state(1);
						SDL_Delay(200);
						Mix_PlayChannel(-1, close_snd, 0);
						draw_menu(0);
						done = 1;
					} else if ( event.key.keysym.sym == SDLK_DOWN || event.key.keysym.sym == SDLK_UP) {
						menu = !menu;
		 				draw_submenu ( alangid, slangid, menu);
					} else if ( event.key.keysym.sym == SDLK_LEFT ) {
						if ( menu ) { 
							alangid--;
							if ( alangid < 0 ) { alangid = language-1; }
						} else {
							slangid--;
							if ( slangid < 0 ) { slangid = subtitle-1; }
						}
		 				draw_submenu ( alangid, slangid, menu);
					} else if ( event.key.keysym.sym == SDLK_RIGHT ) {
						if ( menu ) { 
							alangid++;
							if ( alangid == language ) { alangid = 0; }
						} else {
							slangid++;
							if ( slangid == subtitle ) { slangid = 0; }
						}
		 				draw_submenu ( alangid, slangid, menu);
					}
				}
	        	}
		}
}


void show_text (char *textname) {

	FILE *file, *fopen();
	
	if ( (file = fopen( textname, "r")) == NULL) {
		printf("Can't open %s\n", textname );
		return;
	} else {

		SDL_BlitSurface(textback, NULL , display, NULL);

                dstrect.x = 0;
                dstrect.y = 0;
		dstrect.w = 700;
		dstrect.h = scrollength;

		int tline=0;

		file = fopen( textname, "r");

		TTF_SetFontStyle(font, TTF_STYLE_BOLD);

		dstrect.w = 900;
		dstrect.h = FONTSIZE * 2;
		
	        srcrect.x = 0;
	        srcrect.y = 0;
		srcrect.w = 630;
		srcrect.h = 450;

		textout = TTF_RenderText_Blended( font, rindex( textname,'/'), col_shadow);
		dstrect.x = 72;
		dstrect.y = 27;
		SDL_BlitSurface(textout, &srcrect, display, &dstrect );
		dstrect.x = 71;
		dstrect.y = 26;
		SDL_BlitSurface(textout, &srcrect, display, &dstrect );
		SDL_FreeSurface(textout);
		
		textout = TTF_RenderText_Blended( font, rindex( textname,'/'), col_file);
		dstrect.x = 70;
		dstrect.y = 25;
		SDL_BlitSurface(textout, &srcrect, display, &dstrect );
		SDL_FreeSurface(textout);

		TTF_SetFontStyle(font, TTF_STYLE_NORMAL);


		char buffer[50];

		textfront = SDL_CreateRGBSurface(SDL_HWSURFACE | SDL_SRCCOLORKEY , 610, scrollength, 16, 0, 0, 0, 0);
		SDL_SetColors( textfront, background->format->palette->colors ,0, 255 );
		Uint32 keycolor = SDL_MapRGB( textfront->format, 200, 180, 100);
		SDL_FillRect(textfront, NULL, keycolor  );
		
		while (!feof(file) && ( dstrect.y < scrollength ) ) {
			fgets( buffer, 40, file );

			strcpy(buffer, stringclean(buffer));

			textout = TTF_RenderText_Blended( font, buffer, col_shadow); 
			dstrect.x = 2;
			dstrect.y = 2 + ( tline * FONTSIZE );
			SDL_BlitSurface(textout, NULL, textfront, &dstrect );
			dstrect.x = 1;
			dstrect.y = 1 + ( tline * FONTSIZE );
			SDL_BlitSurface(textout, NULL, textfront, &dstrect );
			SDL_FreeSurface(textout);

			textout = TTF_RenderText_Blended( font, buffer , col_file); 
			dstrect.x = 0;
			dstrect.y = 0 + ( tline * FONTSIZE );
			SDL_BlitSurface(textout, NULL, textfront, &dstrect );
			SDL_FreeSurface(textout);

			tline++;
		}
		fclose(file);

		SDL_SetColorKey(textfront, SDL_RLEACCEL | SDL_SRCCOLORKEY, keycolor ); 

	        srcrect.x = 0;
	        srcrect.y = 0;
		srcrect.w = 610;
		srcrect.h = 400;
		
		dstrect.x = 80;
		dstrect.y = 85;
		dstrect.w = 610;
		dstrect.h = 400;

		int done=0;
		int pos=0;

		SDL_BlitSurface(textfront, &srcrect , display, &dstrect );
		SDL_Flip(display);
		SDL_EnableKeyRepeat( 10 , 10 );
		SDL_Event event;
		while(done == 0) {
			if ( pos > scrollength - 400 ) { 
				pos = scrollength - 400;
			} 
			if (pos < 0) {
				pos =0;
			} 
			if ( srcrect.y != pos ) {
				srcrect.y = pos;
				SDL_BlitSurface(textback, NULL , display, NULL);
				SDL_BlitSurface(textfront, &srcrect , display, &dstrect );
				SDL_UpdateRects( display, 1, &dstrect);
			}
	        	if ( SDL_WaitEvent(&event) ) {
				if ( event.type == SDL_QUIT || event.key.keysym.sym == SDLK_ESCAPE ) { 
					done = 1; 
				}
				if ( event.key.keysym.sym == SDLK_DOWN ) {
					pos += 5;
				} else if ( event.key.keysym.sym == SDLK_UP ) {
					pos -= 5;
				} else if ( event.key.keysym.sym == SDLK_LEFT ) {
					pos -= 25;
				} else if ( event.key.keysym.sym == SDLK_RIGHT ) {
					pos += 25;
				}
	        	}
	        }
	        SDL_FreeSurface(textfront);
		SDL_EnableKeyRepeat( 0 , 0 );
		draw_menu(0);
	}

};


int main( int argc, char *argv[] ) {

#ifdef __linux__
	printf ("Linux detected. Reading mixer settings from /dev/mixer !\n\n");
#endif

	SDL_Init( SDL_INIT_VIDEO );
	SDL_Init( SDL_INIT_AUDIO );
	
	TTF_Init();

	atexit(Mix_CloseAudio);
	atexit(TTF_Quit);
	atexit(SDL_Quit);

	display = SDL_SetVideoMode( SCREEN_WIDTH, SCREEN_HEIGHT, SCREEN_BPP,  SDL_HWSURFACE | SDL_DOUBLEBUF | SDL_NOFRAME);

	backbuffer = SDL_CreateRGBSurface(SDL_HWSURFACE ,SCREEN_WIDTH , SCREEN_HEIGHT , SCREEN_BPP , 0, 0, 0, 0);

	SDL_SetColors(display, colors, 0, 256);

	SDL_ShowCursor(0);


	background = IMG_Load( "data/background.png");
	textback = IMG_Load( "data/textback.png");
	highlight = IMG_Load( "data/highlight.png");
	backlight = IMG_Load( "data/backlight.png");
	frame = IMG_Load( "data/frame.png");
	selectbox = IMG_Load( "data/selectbox.png");
	volume = IMG_Load( "data/volume.png");

	font = TTF_OpenFont( "data/font.ttf", FONTSIZE);
	TTF_SetFontStyle(font, TTF_STYLE_NORMAL);

	char filename[MAXPATHLEN];

	cursor.pane=0;
	cursor.leftentry=0;
	cursor.rightentry=0;
	cursor.level=0;
	strcpy(leftpath, "/");
	strcpy(rightpath, "/");
	
	printf("root dir = %s\n",rootpath);

	SDL_BlitSurface(background, NULL , display, NULL);

	read_dirs(1);
	read_dirs(0);
	draw_menu(0);
	char command[MAXPATHLEN];

	int done=0;

	sound_state(1);
	
                    
	SDL_Event event;
	while(done == 0) {

        	if ( SDL_WaitEvent(&event) ) {

			if ( event.type == SDL_QUIT ) { done = 1; } ;

               		if ( event.type == SDL_KEYDOWN ) { 
				if ( event.key.keysym.mod & KMOD_ALT ) {
               				if ( event.key.keysym.sym == SDLK_ESCAPE ) { done = 1; } 
               			}
				if ( event.key.keysym.mod & KMOD_CTRL ) {
               				if ( event.key.keysym.sym == SDLK_c ) { done = 1; } 
               			}
               			if ( event.key.keysym.sym == SDLK_DOWN ) { 
               				if ( cursor.pane==0 ) {
	               				cursor.leftentry++ ;
						if ( leftpane[cursor.leftentry].type == 4) {
							sprintf( rightpath, "%s/%s", leftpath, leftpane[cursor.leftentry].filename );
							read_dirs(1);
						}
						draw_menu(1);
					} else {
						cursor.rightentry++ ;
						draw_menu(1);
					}
               			} else if ( event.key.keysym.sym == SDLK_UP ) {
               				if ( cursor.pane==0 ) {
	               				cursor.leftentry-- ;
						if ( leftpane[cursor.leftentry].type == 4) {
							sprintf( rightpath, "%s/%s", leftpath, leftpane[cursor.leftentry].filename );
							read_dirs(1);
						}
						draw_menu(1);
					} else {
						cursor.rightentry-- ;
						draw_menu(1);
					}
               			} else if ( event.key.keysym.sym == SDLK_PAGEDOWN ) { 
               				if ( cursor.pane==0 ) {
	               				cursor.leftentry +=4 ;
						if ( leftpane[cursor.leftentry].type == 4) {
							sprintf( rightpath, "%s/%s", leftpath, leftpane[cursor.leftentry].filename );
							read_dirs(1);
						}
						draw_menu(1);
					} else {
						cursor.rightentry +=9 ;
						draw_menu(1);
					}
               			} else if ( event.key.keysym.sym == SDLK_PAGEUP ) {
               				if ( cursor.pane==0 ) {
	               				cursor.leftentry -=4 ;
						if ( leftpane[cursor.leftentry].type == 4) {
							sprintf( rightpath, "%s/%s", leftpath, leftpane[cursor.leftentry].filename );
							read_dirs(1);
						}
						draw_menu(1);
					} else {
						cursor.rightentry -=9 ;
						draw_menu(1);
					}
               			} else if ( event.key.keysym.sym == SDLK_LEFT ) {
					if ( cursor.pane==1 ) {
						cursor.pane=0;
						draw_menu(1);
					} else if ( cursor.level > 0 ) {
						char *c = rindex (leftpath,'/');
						if (c) { 
							int l = strlen(leftpath) - strlen(c) ;
							*(leftpath + l)='\0';
						}
						cursor.rightentry=cursor.leftentry;
						cursor.level--;
						cursor.leftentry=cursor.oldentry[cursor.level];
						read_dirs(0);
						sprintf( rightpath, "%s/%s", leftpath, leftpane[cursor.leftentry].filename );
						read_dirs(1);
						draw_menu(1);
					}
				} else if ( event.key.keysym.sym == SDLK_RIGHT ) {
					if ( cursor.pane==0 ) {
						cursor.pane=1;
						draw_menu(1);
						
					} else if ( rightpane[cursor.rightentry].type == 4 ) {
						strcpy ( leftpath, rightpath );
						sprintf( rightpath, "%s/%s", leftpath, rightpane[cursor.rightentry].filename );
						cursor.oldentry[cursor.level]=cursor.leftentry;
						cursor.level++;
						cursor.leftentry=cursor.rightentry;
						cursor.rightentry=0;
						read_dirs(0);
						read_dirs(1);
						draw_menu(1);
					}
				} else if ( event.key.keysym.sym == SDLK_SPACE || event.key.keysym.sym == SDLK_RETURN ) {
					
					if ( cursor.pane==1 ) {
						sprintf( filename,"%s/%s/%s", rootpath, rightpath, rightpane[cursor.rightentry].filename );
					} else {
						sprintf( filename,"%s/%s/%s", rootpath, leftpath, leftpane[cursor.leftentry].filename );
					}

					char *mime = rindex(filename, '.');
					
					if (mime != NULL) {
						if ( 
						   ( strcmp(mime, ".txt") == 0 )
						|| ( strcmp(mime, ".c") == 0 )
						   ) {
							Mix_PlayChannel(-1, open_snd, 0);
							show_text( filename); 
							Mix_PlayChannel(-1, close_snd, 0);
						} else if ( 
						   ( strcmp(mime, ".ogm") == 0 )
						|| ( strcmp(mime, ".mkv") == 0 )
						   ) {
							select_subtitle(filename);
						} else {
							Mix_PlayChannel(-1, open_snd, 0);
							SDL_Delay(1500);
							sound_state(0);
							sprintf( command, "%s \"%s\"", player, filename);
							system( command );
							printf ("%s (Directory)\n", command );
							sound_state(1);
							Mix_PlayChannel(-1, close_snd, 0);
						}
					} else if ( cursor.pane==1 ) {
						Mix_PlayChannel(-1, open_snd, 0);
						SDL_Delay(1500);
						sound_state(0);
						sprintf( command, "%s \"%s/\"*", player, filename);
						system( command );
						printf ("%s (Directory)\n", command );
						sound_state(1);
						Mix_PlayChannel(-1, close_snd, 0);
					}
					
				}

				printf ( "Key: %d Mod: %d \n", event.key.keysym.sym, event.key.keysym.mod);
				printf( "leftpatch: %s   rightpath: %s\n",leftpath, rightpath );
               		}
               	}
        }

	return 0;
}

